# 题目分类

题目可能存在多种解法，下表仅列举最优解法（时间与空间复杂度最低）的算法和数据结构分类。

| 题目                             | 算法分类         | 数据结构分类   |
| -------------------------------- | ---------------- | -------------- |
| 寻找文件副本                     | 查找             | 数组           |
| 寻找目标值 - 二维数组            | 查找             | 数组           |
| 路径加密                         |                  | 字符串         |
| 图书整理 I                       |                  | 栈与队列，链表 |
| 推理二叉树                       | 分治             | 树，哈希表     |
| 图书整理 II                      |                  | 栈与队列       |
| 斐波那契数                       | 动态规划         | 数组           |
| 跳跃训练                         | 动态规划         | 数组           |
| 库存管理 I                       | 查找             | 数组           |
| 字母迷宫                         | 回溯，搜索       | 数组，图       |
| 衣橱整理                         | 回溯，搜索       | 数组，图       |
| 砍竹子 I                         | 贪心，数学       |                |
| 砍竹子 II                        | 贪心，分治，数学 |                |
| 位 1 的个数                      | 位运算           |                |
| Pow(x, n)                        | 分治，位运算     |                |
| 报数                             |                  | 数组           |
| 删除链表节点                     | 双指针           | 链表           |
| 模糊搜索验证                     | 动态规划         | 字符串         |
| 有效数字                         |                  | 字符串         |
| 训练计划 I                       | 双指针           | 数组           |
| 训练计划 II                      | 双指针           | 链表           |
| 训练计划 III                     | 双指针           | 链表           |
| 训练计划 IV                      | 双指针           | 链表           |
| 子结构判断                       | 搜索             | 树             |
| 翻转二叉树                       | 搜索             | 栈与队列，树   |
| 判断对称二叉树                   | 搜索             | 树             |
| 螺旋遍历二维数组                 | 模拟             | 数组           |
| 最小栈                           | 排序             | 栈与队列       |
| 验证图书取出顺序                 | 模拟             | 栈与队列       |
| 彩灯装饰记录 I                   | 搜索             | 栈与队列，树   |
| 彩灯装饰记录 II                  | 搜索             | 栈与队列，树   |
| 彩灯装饰记录 III                 | 搜索             | 栈与队列，树   |
| 验证二叉搜索树的后序遍历序列     | 分治             | 栈与队列，树   |
| 二叉树中和为目标值的路径         | 回溯，搜索       | 树             |
| 随机链表的复制                   |                  | 链表           |
| 将二叉搜索树转化为排序的双向链表 | 搜索，双指针     | 树             |
| 序列化与反序列化二叉树           | 搜索             | 树             |
| 套餐内商品的排列顺序             | 回溯             | 字符串，哈希表 |
| 库存管理 II                      |                  | 数组           |
| 库存管理 III                     | 排序             | 数组，堆       |
| 数据流中的中位数                 | 排序             | 堆             |
| 连续天数的最高销售额             | 动态规划         | 数组           |
| 数字 1 的个数                    | 数学             |                |
| 找到第 k 位数字                  | 数学             |                |
| 破解闯关密码                     | 排序             | 字符串         |
| 解密数字                         | 动态规划         | 字符串         |
| 珠宝的最高价值                   | 动态规划         | 数组           |
| 招式拆解 I                       | 动态规划，双指针 | 哈希表         |
| 丑数                             | 动态规划         |                |
| 招式拆解 II                      |                  | 哈希表         |
| 交易逆序对的总数                 | 分治             | 数组           |
| 训练计划 V                       | 双指针           | 链表           |
| 统计目标成绩的出现次数           | 查找             | 数组           |
| 点名                             | 查找             | 数组           |
| 寻找二叉搜索树中的目标节点       | 搜索             | 树             |
| 计算二叉树的深度                 | 搜索             | 树             |
| 判断是否为平衡二叉树             | 搜索             | 树             |
| 撞色搭配                         | 位运算           | 数组           |
| 训练计划 VI                      | 位运算           | 数组           |
| 查找总价格为目标值的两个商品     | 双指针           | 数组           |
| 文件组合                         | 双指针           | 数组           |
| 字符串中的单词反转               | 双指针           | 字符串         |
| 动态口令                         |                  | 字符串         |
| 望远镜中最高的海拔               | 排序             | 数组，栈与队列 |
| 设计自助结算系统                 | 排序             | 数组，栈与队列 |
| 统计结果概率                     | 动态规划         |                |
| 文物朝代判断                     | 排序             | 数组，哈希表   |
| 破冰游戏                         | 数学             |                |
| 买卖芯片的最佳时机               | 动态规划         | 数组           |
| 设计机械累加器                   |                  |                |
| 加密运算                         | 位运算           |                |
| 按规则计算统计结果               | 数学             | 数组           |
| 不使用库函数的字符串转整数       |                  | 字符串         |
| 求二叉搜索树的最近公共祖先       | 搜索             | 树             |
| 寻找二叉树的最近公共祖先         | 搜索             | 树             |
